#!/bin/sh

TP_FORM_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_FORM_RESULT_DATA=""

TP_FORM_RESULT_OK="DTAS[TUI]@{OK}"
TP_FORM_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_FORM_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_FORM_RESULT_CODE=""

TP_FORM_RESULT_MSG=""

tp_form() {
	debug_print "${0}" "${LINENO}" 'in function "tp_form"'

	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"
	local form_data="${5}"
	local form_height="${6:-0}"
	
	exec 3>&1
	local ret=`sh -c "dialog \
		--backtitle    \"${CONS_BACK_TITLE}\" \
		--title        \"${title}\" \
		--ok-label     \"${label_ok}\" \
		--cancel-label \"${label_cancel}\" \
		--form         \"${text}\" \"${CONS_BOX_HEIGHT}\" \"${CONS_BOX_WIDTH}\" ${form_height} \
		${form_data} \
		2>&1 1>&3"; \
		case "${?}" in \
			1|255) echo "${TP_FORM_RESULT_CANCEL}" ;; \
		esac`
	exec 3>&-
	
	debug_print "${0}" "${LINENO}" "Ret: ${ret}"
    case "${ret}" in
        # press CANCEL or ESC
        "${TP_FORM_RESULT_CANCEL}") 
            TP_FORM_RESULT_CODE="${TP_FORM_RESULT_CANCEL}"
            TP_FORM_RESULT_DATA="${TP_FORM_RESULT_NULL}"
            TP_FORM_RESULT_MSG=""
            ;;
        *)
			TP_FORM_RESULT_CODE="${TP_FORM_RESULT_OK}"
			TP_FORM_RESULT_DATA="${ret}"
			TP_FORM_RESULT_MSG=""
			;;
    esac
}
